package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{
  CampaignId,
  Identity,
  ImageUrl,
  Ip,
  Percentage,
  Timestamp,
  Esp,
  Subject,
  Volume
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DomainDeliverabilityCampaign(
    campaignId: Option[CampaignId] = None,
    imageUrl: Option[ImageUrl] = None,
    subject: Option[Subject] = None,
    fromAddress: Option[Identity] = None,
    sendingIps: Option[Iterable[Ip]] = None,
    firstSeenDateTime: Option[Timestamp] = None,
    lastSeenDateTime: Option[Timestamp] = None,
    inboxCount: Option[Volume] = None,
    spamCount: Option[Volume] = None,
    readRate: Option[Percentage] = None,
    deleteRate: Option[Percentage] = None,
    readDeleteRate: Option[Percentage] = None,
    projectedVolume: Option[Volume] = None,
    esps: Option[Iterable[Esp]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityCampaign = {
    import DomainDeliverabilityCampaign.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityCampaign
      .builder()
      .optionallyWith(
        campaignId.map(value => CampaignId.unwrap(value): java.lang.String)
      )(_.campaignId)
      .optionallyWith(
        imageUrl.map(value => ImageUrl.unwrap(value): java.lang.String)
      )(_.imageUrl)
      .optionallyWith(
        subject.map(value => Subject.unwrap(value): java.lang.String)
      )(_.subject)
      .optionallyWith(
        fromAddress.map(value => Identity.unwrap(value): java.lang.String)
      )(_.fromAddress)
      .optionallyWith(
        sendingIps.map(value =>
          value.map { item =>
            Ip.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sendingIps)
      .optionallyWith(
        firstSeenDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.firstSeenDateTime)
      .optionallyWith(
        lastSeenDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastSeenDateTime)
      .optionallyWith(
        inboxCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.inboxCount)
      .optionallyWith(
        spamCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.spamCount)
      .optionallyWith(
        readRate.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.readRate)
      .optionallyWith(
        deleteRate.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.deleteRate)
      .optionallyWith(
        readDeleteRate.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.readDeleteRate)
      .optionallyWith(
        projectedVolume.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.projectedVolume)
      .optionallyWith(
        esps.map(value =>
          value.map { item =>
            Esp.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.esps)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly =
    zio.aws.pinpointemail.model.DomainDeliverabilityCampaign
      .wrap(buildAwsValue())
}
object DomainDeliverabilityCampaign {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityCampaign
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.DomainDeliverabilityCampaign =
      zio.aws.pinpointemail.model.DomainDeliverabilityCampaign(
        campaignId.map(value => value),
        imageUrl.map(value => value),
        subject.map(value => value),
        fromAddress.map(value => value),
        sendingIps.map(value => value),
        firstSeenDateTime.map(value => value),
        lastSeenDateTime.map(value => value),
        inboxCount.map(value => value),
        spamCount.map(value => value),
        readRate.map(value => value),
        deleteRate.map(value => value),
        readDeleteRate.map(value => value),
        projectedVolume.map(value => value),
        esps.map(value => value)
      )
    def campaignId: Option[CampaignId]
    def imageUrl: Option[ImageUrl]
    def subject: Option[Subject]
    def fromAddress: Option[Identity]
    def sendingIps: Option[List[Ip]]
    def firstSeenDateTime: Option[Timestamp]
    def lastSeenDateTime: Option[Timestamp]
    def inboxCount: Option[Volume]
    def spamCount: Option[Volume]
    def readRate: Option[Percentage]
    def deleteRate: Option[Percentage]
    def readDeleteRate: Option[Percentage]
    def projectedVolume: Option[Volume]
    def esps: Option[List[Esp]]
    def getCampaignId: ZIO[Any, AwsError, CampaignId] =
      AwsError.unwrapOptionField("campaignId", campaignId)
    def getImageUrl: ZIO[Any, AwsError, ImageUrl] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getSubject: ZIO[Any, AwsError, Subject] =
      AwsError.unwrapOptionField("subject", subject)
    def getFromAddress: ZIO[Any, AwsError, Identity] =
      AwsError.unwrapOptionField("fromAddress", fromAddress)
    def getSendingIps: ZIO[Any, AwsError, List[Ip]] =
      AwsError.unwrapOptionField("sendingIps", sendingIps)
    def getFirstSeenDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("firstSeenDateTime", firstSeenDateTime)
    def getLastSeenDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastSeenDateTime", lastSeenDateTime)
    def getInboxCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("inboxCount", inboxCount)
    def getSpamCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("spamCount", spamCount)
    def getReadRate: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("readRate", readRate)
    def getDeleteRate: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("deleteRate", deleteRate)
    def getReadDeleteRate: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("readDeleteRate", readDeleteRate)
    def getProjectedVolume: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("projectedVolume", projectedVolume)
    def getEsps: ZIO[Any, AwsError, List[Esp]] =
      AwsError.unwrapOptionField("esps", esps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityCampaign
  ) extends zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly {
    override val campaignId: Option[CampaignId] = scala
      .Option(impl.campaignId())
      .map(value => zio.aws.pinpointemail.model.primitives.CampaignId(value))
    override val imageUrl: Option[ImageUrl] = scala
      .Option(impl.imageUrl())
      .map(value => zio.aws.pinpointemail.model.primitives.ImageUrl(value))
    override val subject: Option[Subject] = scala
      .Option(impl.subject())
      .map(value => zio.aws.pinpointemail.model.primitives.Subject(value))
    override val fromAddress: Option[Identity] = scala
      .Option(impl.fromAddress())
      .map(value => zio.aws.pinpointemail.model.primitives.Identity(value))
    override val sendingIps: Option[List[Ip]] = scala
      .Option(impl.sendingIps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.primitives.Ip(item)
        }.toList
      )
    override val firstSeenDateTime: Option[Timestamp] = scala
      .Option(impl.firstSeenDateTime())
      .map(value => zio.aws.pinpointemail.model.primitives.Timestamp(value))
    override val lastSeenDateTime: Option[Timestamp] = scala
      .Option(impl.lastSeenDateTime())
      .map(value => zio.aws.pinpointemail.model.primitives.Timestamp(value))
    override val inboxCount: Option[Volume] = scala
      .Option(impl.inboxCount())
      .map(value => zio.aws.pinpointemail.model.primitives.Volume(value))
    override val spamCount: Option[Volume] = scala
      .Option(impl.spamCount())
      .map(value => zio.aws.pinpointemail.model.primitives.Volume(value))
    override val readRate: Option[Percentage] = scala
      .Option(impl.readRate())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
    override val deleteRate: Option[Percentage] = scala
      .Option(impl.deleteRate())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
    override val readDeleteRate: Option[Percentage] = scala
      .Option(impl.readDeleteRate())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
    override val projectedVolume: Option[Volume] = scala
      .Option(impl.projectedVolume())
      .map(value => zio.aws.pinpointemail.model.primitives.Volume(value))
    override val esps: Option[List[Esp]] = scala
      .Option(impl.esps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.primitives.Esp(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityCampaign
  ): zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly =
    new Wrapper(impl)
}
