package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WriteSegmentRequest(
    dimensions: Optional[zio.aws.pinpoint.model.SegmentDimensions] =
      Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    segmentGroups: Optional[zio.aws.pinpoint.model.SegmentGroupList] =
      Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest = {
    import WriteSegmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest
      .builder()
      .optionallyWith(dimensions.map(value => value.buildAwsValue()))(
        _.dimensions
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(segmentGroups.map(value => value.buildAwsValue()))(
        _.segmentGroups
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly =
    zio.aws.pinpoint.model.WriteSegmentRequest.wrap(buildAwsValue())
}
object WriteSegmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WriteSegmentRequest =
      zio.aws.pinpoint.model.WriteSegmentRequest(
        dimensions.map(value => value.asEditable),
        name.map(value => value),
        segmentGroups.map(value => value.asEditable),
        tags.map(value => value)
      )
    def dimensions: Optional[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly]
    def name: Optional[__string]
    def segmentGroups
        : Optional[zio.aws.pinpoint.model.SegmentGroupList.ReadOnly]
    def tags: Optional[Map[__string, __string]]
    def getDimensions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SegmentDimensions.ReadOnly
    ] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getSegmentGroups
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentGroupList.ReadOnly] =
      AwsError.unwrapOptionField("segmentGroups", segmentGroups)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest
  ) extends zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly {
    override val dimensions
        : Optional[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value => zio.aws.pinpoint.model.SegmentDimensions.wrap(value))
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val segmentGroups
        : Optional[zio.aws.pinpoint.model.SegmentGroupList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentGroups())
        .map(value => zio.aws.pinpoint.model.SegmentGroupList.wrap(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest
  ): zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly = new Wrapper(impl)
}
