package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WriteJourneyRequest(
    activities: Optional[Map[__string, zio.aws.pinpoint.model.Activity]] =
      Optional.Absent,
    creationDate: Optional[__string] = Optional.Absent,
    lastModifiedDate: Optional[__string] = Optional.Absent,
    limits: Optional[zio.aws.pinpoint.model.JourneyLimits] = Optional.Absent,
    localTime: Optional[__boolean] = Optional.Absent,
    name: __string,
    quietTime: Optional[zio.aws.pinpoint.model.QuietTime] = Optional.Absent,
    refreshFrequency: Optional[__string] = Optional.Absent,
    schedule: Optional[zio.aws.pinpoint.model.JourneySchedule] =
      Optional.Absent,
    startActivity: Optional[__string] = Optional.Absent,
    startCondition: Optional[zio.aws.pinpoint.model.StartCondition] =
      Optional.Absent,
    state: Optional[zio.aws.pinpoint.model.State] = Optional.Absent,
    waitForQuietTime: Optional[__boolean] = Optional.Absent,
    refreshOnSegmentUpdate: Optional[__boolean] = Optional.Absent,
    journeyChannelSettings: Optional[
      zio.aws.pinpoint.model.JourneyChannelSettings
    ] = Optional.Absent,
    sendingSchedule: Optional[__boolean] = Optional.Absent,
    openHours: Optional[zio.aws.pinpoint.model.OpenHours] = Optional.Absent,
    closedDays: Optional[zio.aws.pinpoint.model.ClosedDays] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest = {
    import WriteJourneyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest
      .builder()
      .optionallyWith(
        activities.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.activities)
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.String))(
        _.lastModifiedDate
      )
      .optionallyWith(limits.map(value => value.buildAwsValue()))(_.limits)
      .optionallyWith(localTime.map(value => value: java.lang.Boolean))(
        _.localTime
      )
      .name(name: java.lang.String)
      .optionallyWith(quietTime.map(value => value.buildAwsValue()))(
        _.quietTime
      )
      .optionallyWith(refreshFrequency.map(value => value: java.lang.String))(
        _.refreshFrequency
      )
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(startActivity.map(value => value: java.lang.String))(
        _.startActivity
      )
      .optionallyWith(startCondition.map(value => value.buildAwsValue()))(
        _.startCondition
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(waitForQuietTime.map(value => value: java.lang.Boolean))(
        _.waitForQuietTime
      )
      .optionallyWith(
        refreshOnSegmentUpdate.map(value => value: java.lang.Boolean)
      )(_.refreshOnSegmentUpdate)
      .optionallyWith(
        journeyChannelSettings.map(value => value.buildAwsValue())
      )(_.journeyChannelSettings)
      .optionallyWith(sendingSchedule.map(value => value: java.lang.Boolean))(
        _.sendingSchedule
      )
      .optionallyWith(openHours.map(value => value.buildAwsValue()))(
        _.openHours
      )
      .optionallyWith(closedDays.map(value => value.buildAwsValue()))(
        _.closedDays
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly =
    zio.aws.pinpoint.model.WriteJourneyRequest.wrap(buildAwsValue())
}
object WriteJourneyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WriteJourneyRequest =
      zio.aws.pinpoint.model.WriteJourneyRequest(
        activities.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        limits.map(value => value.asEditable),
        localTime.map(value => value),
        name,
        quietTime.map(value => value.asEditable),
        refreshFrequency.map(value => value),
        schedule.map(value => value.asEditable),
        startActivity.map(value => value),
        startCondition.map(value => value.asEditable),
        state.map(value => value),
        waitForQuietTime.map(value => value),
        refreshOnSegmentUpdate.map(value => value),
        journeyChannelSettings.map(value => value.asEditable),
        sendingSchedule.map(value => value),
        openHours.map(value => value.asEditable),
        closedDays.map(value => value.asEditable)
      )
    def activities
        : Optional[Map[__string, zio.aws.pinpoint.model.Activity.ReadOnly]]
    def creationDate: Optional[__string]
    def lastModifiedDate: Optional[__string]
    def limits: Optional[zio.aws.pinpoint.model.JourneyLimits.ReadOnly]
    def localTime: Optional[__boolean]
    def name: __string
    def quietTime: Optional[zio.aws.pinpoint.model.QuietTime.ReadOnly]
    def refreshFrequency: Optional[__string]
    def schedule: Optional[zio.aws.pinpoint.model.JourneySchedule.ReadOnly]
    def startActivity: Optional[__string]
    def startCondition: Optional[zio.aws.pinpoint.model.StartCondition.ReadOnly]
    def state: Optional[zio.aws.pinpoint.model.State]
    def waitForQuietTime: Optional[__boolean]
    def refreshOnSegmentUpdate: Optional[__boolean]
    def journeyChannelSettings
        : Optional[zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly]
    def sendingSchedule: Optional[__boolean]
    def openHours: Optional[zio.aws.pinpoint.model.OpenHours.ReadOnly]
    def closedDays: Optional[zio.aws.pinpoint.model.ClosedDays.ReadOnly]
    def getActivities: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.Activity.ReadOnly
    ]] = AwsError.unwrapOptionField("activities", activities)
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLimits
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.JourneyLimits.ReadOnly] =
      AwsError.unwrapOptionField("limits", limits)
    def getLocalTime: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("localTime", localTime)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getQuietTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      AwsError.unwrapOptionField("quietTime", quietTime)
    def getRefreshFrequency: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("refreshFrequency", refreshFrequency)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.JourneySchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getStartActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("startActivity", startActivity)
    def getStartCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.StartCondition.ReadOnly] =
      AwsError.unwrapOptionField("startCondition", startCondition)
    def getState: ZIO[Any, AwsError, zio.aws.pinpoint.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getWaitForQuietTime: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("waitForQuietTime", waitForQuietTime)
    def getRefreshOnSegmentUpdate: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("refreshOnSegmentUpdate", refreshOnSegmentUpdate)
    def getJourneyChannelSettings: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "journeyChannelSettings",
      journeyChannelSettings
    )
    def getSendingSchedule: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("sendingSchedule", sendingSchedule)
    def getOpenHours
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.OpenHours.ReadOnly] =
      AwsError.unwrapOptionField("openHours", openHours)
    def getClosedDays
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.ClosedDays.ReadOnly] =
      AwsError.unwrapOptionField("closedDays", closedDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest
  ) extends zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly {
    override val activities
        : Optional[Map[__string, zio.aws.pinpoint.model.Activity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activities())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.pinpoint.model.Activity.wrap(value)
            })
            .toMap
        )
    override val creationDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: __string)
    override val lastModifiedDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: __string)
    override val limits
        : Optional[zio.aws.pinpoint.model.JourneyLimits.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limits())
        .map(value => zio.aws.pinpoint.model.JourneyLimits.wrap(value))
    override val localTime: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.localTime())
      .map(value => value: __boolean)
    override val name: __string = impl.name(): __string
    override val quietTime
        : Optional[zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quietTime())
        .map(value => zio.aws.pinpoint.model.QuietTime.wrap(value))
    override val refreshFrequency: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshFrequency())
      .map(value => value: __string)
    override val schedule
        : Optional[zio.aws.pinpoint.model.JourneySchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.pinpoint.model.JourneySchedule.wrap(value))
    override val startActivity: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.startActivity())
      .map(value => value: __string)
    override val startCondition
        : Optional[zio.aws.pinpoint.model.StartCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startCondition())
        .map(value => zio.aws.pinpoint.model.StartCondition.wrap(value))
    override val state: Optional[zio.aws.pinpoint.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.pinpoint.model.State.wrap(value))
    override val waitForQuietTime: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.waitForQuietTime())
      .map(value => value: __boolean)
    override val refreshOnSegmentUpdate: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.refreshOnSegmentUpdate())
        .map(value => value: __boolean)
    override val journeyChannelSettings
        : Optional[zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.journeyChannelSettings())
        .map(value => zio.aws.pinpoint.model.JourneyChannelSettings.wrap(value))
    override val sendingSchedule: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingSchedule())
      .map(value => value: __boolean)
    override val openHours
        : Optional[zio.aws.pinpoint.model.OpenHours.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openHours())
        .map(value => zio.aws.pinpoint.model.OpenHours.wrap(value))
    override val closedDays
        : Optional[zio.aws.pinpoint.model.ClosedDays.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.closedDays())
        .map(value => zio.aws.pinpoint.model.ClosedDays.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest
  ): zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly = new Wrapper(impl)
}
