package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePushTemplateRequest(
    createNewVersion: Optional[__boolean] = Optional.Absent,
    pushNotificationTemplateRequest: zio.aws.pinpoint.model.PushNotificationTemplateRequest,
    templateName: __string,
    version: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest = {
    import UpdatePushTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest
      .builder()
      .optionallyWith(createNewVersion.map(value => value: java.lang.Boolean))(
        _.createNewVersion
      )
      .pushNotificationTemplateRequest(
        pushNotificationTemplateRequest.buildAwsValue()
      )
      .templateName(templateName: java.lang.String)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdatePushTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdatePushTemplateRequest.wrap(buildAwsValue())
}
object UpdatePushTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdatePushTemplateRequest =
      zio.aws.pinpoint.model.UpdatePushTemplateRequest(
        createNewVersion.map(value => value),
        pushNotificationTemplateRequest.asEditable,
        templateName,
        version.map(value => value)
      )
    def createNewVersion: Optional[__boolean]
    def pushNotificationTemplateRequest
        : zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly
    def templateName: __string
    def version: Optional[__string]
    def getCreateNewVersion: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("createNewVersion", createNewVersion)
    def getPushNotificationTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly
    ] = ZIO.succeed(pushNotificationTemplateRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest
  ) extends zio.aws.pinpoint.model.UpdatePushTemplateRequest.ReadOnly {
    override val createNewVersion: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.createNewVersion())
      .map(value => value: __boolean)
    override val pushNotificationTemplateRequest
        : zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.PushNotificationTemplateRequest
        .wrap(impl.pushNotificationTemplateRequest())
    override val templateName: __string = impl.templateName(): __string
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest
  ): zio.aws.pinpoint.model.UpdatePushTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
