package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateEmailTemplateResponse(
    messageBody: zio.aws.pinpoint.model.MessageBody
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateResponse = {
    import UpdateEmailTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateResponse
      .builder()
      .messageBody(messageBody.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateEmailTemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.UpdateEmailTemplateResponse.wrap(buildAwsValue())
}
object UpdateEmailTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateEmailTemplateResponse =
      zio.aws.pinpoint.model.UpdateEmailTemplateResponse(messageBody.asEditable)
    def messageBody: zio.aws.pinpoint.model.MessageBody.ReadOnly
    def getMessageBody
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.MessageBody.ReadOnly] =
      ZIO.succeed(messageBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateResponse
  ) extends zio.aws.pinpoint.model.UpdateEmailTemplateResponse.ReadOnly {
    override val messageBody: zio.aws.pinpoint.model.MessageBody.ReadOnly =
      zio.aws.pinpoint.model.MessageBody.wrap(impl.messageBody())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateResponse
  ): zio.aws.pinpoint.model.UpdateEmailTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
