package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateApplicationSettingsRequest(
    applicationId: __string,
    writeApplicationSettingsRequest: zio.aws.pinpoint.model.WriteApplicationSettingsRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest = {
    import UpdateApplicationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .writeApplicationSettingsRequest(
        writeApplicationSettingsRequest.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.UpdateApplicationSettingsRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateApplicationSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateApplicationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateApplicationSettingsRequest =
      zio.aws.pinpoint.model.UpdateApplicationSettingsRequest(
        applicationId,
        writeApplicationSettingsRequest.asEditable
      )
    def applicationId: __string
    def writeApplicationSettingsRequest
        : zio.aws.pinpoint.model.WriteApplicationSettingsRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getWriteApplicationSettingsRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.WriteApplicationSettingsRequest.ReadOnly
    ] = ZIO.succeed(writeApplicationSettingsRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest
  ) extends zio.aws.pinpoint.model.UpdateApplicationSettingsRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val writeApplicationSettingsRequest
        : zio.aws.pinpoint.model.WriteApplicationSettingsRequest.ReadOnly =
      zio.aws.pinpoint.model.WriteApplicationSettingsRequest
        .wrap(impl.writeApplicationSettingsRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest
  ): zio.aws.pinpoint.model.UpdateApplicationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
