package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TreatmentResource(
    customDeliveryConfiguration: Optional[
      zio.aws.pinpoint.model.CustomDeliveryConfiguration
    ] = Optional.Absent,
    id: __string,
    messageConfiguration: Optional[
      zio.aws.pinpoint.model.MessageConfiguration
    ] = Optional.Absent,
    schedule: Optional[zio.aws.pinpoint.model.Schedule] = Optional.Absent,
    sizePercent: __integer,
    state: Optional[zio.aws.pinpoint.model.CampaignState] = Optional.Absent,
    templateConfiguration: Optional[
      zio.aws.pinpoint.model.TemplateConfiguration
    ] = Optional.Absent,
    treatmentDescription: Optional[__string] = Optional.Absent,
    treatmentName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TreatmentResource = {
    import TreatmentResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TreatmentResource
      .builder()
      .optionallyWith(
        customDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.customDeliveryConfiguration)
      .id(id: java.lang.String)
      .optionallyWith(messageConfiguration.map(value => value.buildAwsValue()))(
        _.messageConfiguration
      )
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .sizePercent(sizePercent: Integer)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        templateConfiguration.map(value => value.buildAwsValue())
      )(_.templateConfiguration)
      .optionallyWith(
        treatmentDescription.map(value => value: java.lang.String)
      )(_.treatmentDescription)
      .optionallyWith(treatmentName.map(value => value: java.lang.String))(
        _.treatmentName
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TreatmentResource.ReadOnly =
    zio.aws.pinpoint.model.TreatmentResource.wrap(buildAwsValue())
}
object TreatmentResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TreatmentResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TreatmentResource =
      zio.aws.pinpoint.model.TreatmentResource(
        customDeliveryConfiguration.map(value => value.asEditable),
        id,
        messageConfiguration.map(value => value.asEditable),
        schedule.map(value => value.asEditable),
        sizePercent,
        state.map(value => value.asEditable),
        templateConfiguration.map(value => value.asEditable),
        treatmentDescription.map(value => value),
        treatmentName.map(value => value)
      )
    def customDeliveryConfiguration
        : Optional[zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly]
    def id: __string
    def messageConfiguration
        : Optional[zio.aws.pinpoint.model.MessageConfiguration.ReadOnly]
    def schedule: Optional[zio.aws.pinpoint.model.Schedule.ReadOnly]
    def sizePercent: __integer
    def state: Optional[zio.aws.pinpoint.model.CampaignState.ReadOnly]
    def templateConfiguration
        : Optional[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly]
    def treatmentDescription: Optional[__string]
    def treatmentName: Optional[__string]
    def getCustomDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDeliveryConfiguration",
      customDeliveryConfiguration
    )
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getMessageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.MessageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("messageConfiguration", messageConfiguration)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getSizePercent: ZIO[Any, Nothing, __integer] = ZIO.succeed(sizePercent)
    def getState
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getTemplateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("templateConfiguration", templateConfiguration)
    def getTreatmentDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentDescription", treatmentDescription)
    def getTreatmentName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentName", treatmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TreatmentResource
  ) extends zio.aws.pinpoint.model.TreatmentResource.ReadOnly {
    override val customDeliveryConfiguration: Optional[
      zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customDeliveryConfiguration())
      .map(value =>
        zio.aws.pinpoint.model.CustomDeliveryConfiguration.wrap(value)
      )
    override val id: __string = impl.id(): __string
    override val messageConfiguration
        : Optional[zio.aws.pinpoint.model.MessageConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageConfiguration())
        .map(value => zio.aws.pinpoint.model.MessageConfiguration.wrap(value))
    override val schedule: Optional[zio.aws.pinpoint.model.Schedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.pinpoint.model.Schedule.wrap(value))
    override val sizePercent: __integer = impl.sizePercent(): __integer
    override val state
        : Optional[zio.aws.pinpoint.model.CampaignState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.pinpoint.model.CampaignState.wrap(value))
    override val templateConfiguration
        : Optional[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateConfiguration())
        .map(value => zio.aws.pinpoint.model.TemplateConfiguration.wrap(value))
    override val treatmentDescription: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.treatmentDescription())
        .map(value => value: __string)
    override val treatmentName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.treatmentName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TreatmentResource
  ): zio.aws.pinpoint.model.TreatmentResource.ReadOnly = new Wrapper(impl)
}
