package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateVersionResponse(
    creationDate: __string,
    defaultSubstitutions: Optional[__string] = Optional.Absent,
    lastModifiedDate: __string,
    templateDescription: Optional[__string] = Optional.Absent,
    templateName: __string,
    templateType: __string,
    version: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TemplateVersionResponse = {
    import TemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TemplateVersionResponse
      .builder()
      .creationDate(creationDate: java.lang.String)
      .optionallyWith(
        defaultSubstitutions.map(value => value: java.lang.String)
      )(_.defaultSubstitutions)
      .lastModifiedDate(lastModifiedDate: java.lang.String)
      .optionallyWith(
        templateDescription.map(value => value: java.lang.String)
      )(_.templateDescription)
      .templateName(templateName: java.lang.String)
      .templateType(templateType: java.lang.String)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TemplateVersionResponse.ReadOnly =
    zio.aws.pinpoint.model.TemplateVersionResponse.wrap(buildAwsValue())
}
object TemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TemplateVersionResponse =
      zio.aws.pinpoint.model.TemplateVersionResponse(
        creationDate,
        defaultSubstitutions.map(value => value),
        lastModifiedDate,
        templateDescription.map(value => value),
        templateName,
        templateType,
        version.map(value => value)
      )
    def creationDate: __string
    def defaultSubstitutions: Optional[__string]
    def lastModifiedDate: __string
    def templateDescription: Optional[__string]
    def templateName: __string
    def templateType: __string
    def version: Optional[__string]
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType: ZIO[Any, Nothing, __string] = ZIO.succeed(templateType)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateVersionResponse
  ) extends zio.aws.pinpoint.model.TemplateVersionResponse.ReadOnly {
    override val creationDate: __string = impl.creationDate(): __string
    override val defaultSubstitutions: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultSubstitutions())
        .map(value => value: __string)
    override val lastModifiedDate: __string = impl.lastModifiedDate(): __string
    override val templateDescription: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateDescription())
      .map(value => value: __string)
    override val templateName: __string = impl.templateName(): __string
    override val templateType: __string = impl.templateType(): __string
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateVersionResponse
  ): zio.aws.pinpoint.model.TemplateVersionResponse.ReadOnly = new Wrapper(impl)
}
