package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SimpleEmail(
    htmlPart: Optional[zio.aws.pinpoint.model.SimpleEmailPart] =
      Optional.Absent,
    subject: Optional[zio.aws.pinpoint.model.SimpleEmailPart] = Optional.Absent,
    textPart: Optional[zio.aws.pinpoint.model.SimpleEmailPart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SimpleEmail = {
    import SimpleEmail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SimpleEmail
      .builder()
      .optionallyWith(htmlPart.map(value => value.buildAwsValue()))(_.htmlPart)
      .optionallyWith(subject.map(value => value.buildAwsValue()))(_.subject)
      .optionallyWith(textPart.map(value => value.buildAwsValue()))(_.textPart)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SimpleEmail.ReadOnly =
    zio.aws.pinpoint.model.SimpleEmail.wrap(buildAwsValue())
}
object SimpleEmail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SimpleEmail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SimpleEmail =
      zio.aws.pinpoint.model.SimpleEmail(
        htmlPart.map(value => value.asEditable),
        subject.map(value => value.asEditable),
        textPart.map(value => value.asEditable)
      )
    def htmlPart: Optional[zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly]
    def subject: Optional[zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly]
    def textPart: Optional[zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly]
    def getHtmlPart
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly] =
      AwsError.unwrapOptionField("htmlPart", htmlPart)
    def getSubject
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly] =
      AwsError.unwrapOptionField("subject", subject)
    def getTextPart
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly] =
      AwsError.unwrapOptionField("textPart", textPart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SimpleEmail
  ) extends zio.aws.pinpoint.model.SimpleEmail.ReadOnly {
    override val htmlPart
        : Optional[zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.htmlPart())
        .map(value => zio.aws.pinpoint.model.SimpleEmailPart.wrap(value))
    override val subject
        : Optional[zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subject())
        .map(value => zio.aws.pinpoint.model.SimpleEmailPart.wrap(value))
    override val textPart
        : Optional[zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textPart())
        .map(value => zio.aws.pinpoint.model.SimpleEmailPart.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SimpleEmail
  ): zio.aws.pinpoint.model.SimpleEmail.ReadOnly = new Wrapper(impl)
}
