package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__string, __integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Session(
    duration: Optional[__integer] = Optional.Absent,
    id: __string,
    startTimestamp: __string,
    stopTimestamp: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.Session = {
    import Session.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Session
      .builder()
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .id(id: java.lang.String)
      .startTimestamp(startTimestamp: java.lang.String)
      .optionallyWith(stopTimestamp.map(value => value: java.lang.String))(
        _.stopTimestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Session.ReadOnly =
    zio.aws.pinpoint.model.Session.wrap(buildAwsValue())
}
object Session {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.Session] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Session =
      zio.aws.pinpoint.model.Session(
        duration.map(value => value),
        id,
        startTimestamp,
        stopTimestamp.map(value => value)
      )
    def duration: Optional[__integer]
    def id: __string
    def startTimestamp: __string
    def stopTimestamp: Optional[__string]
    def getDuration: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getStartTimestamp: ZIO[Any, Nothing, __string] =
      ZIO.succeed(startTimestamp)
    def getStopTimestamp: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("stopTimestamp", stopTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Session
  ) extends zio.aws.pinpoint.model.Session.ReadOnly {
    override val duration: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: __integer)
    override val id: __string = impl.id(): __string
    override val startTimestamp: __string = impl.startTimestamp(): __string
    override val stopTimestamp: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTimestamp())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Session
  ): zio.aws.pinpoint.model.Session.ReadOnly = new Wrapper(impl)
}
