package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__string, __integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SendOTPMessageRequestParameters(
    allowedAttempts: Optional[__integer] = Optional.Absent,
    brandName: __string,
    channel: __string,
    codeLength: Optional[__integer] = Optional.Absent,
    destinationIdentity: __string,
    entityId: Optional[__string] = Optional.Absent,
    language: Optional[__string] = Optional.Absent,
    originationIdentity: __string,
    referenceId: __string,
    templateId: Optional[__string] = Optional.Absent,
    validityPeriod: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SendOTPMessageRequestParameters = {
    import SendOTPMessageRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SendOTPMessageRequestParameters
      .builder()
      .optionallyWith(allowedAttempts.map(value => value: Integer))(
        _.allowedAttempts
      )
      .brandName(brandName: java.lang.String)
      .channel(channel: java.lang.String)
      .optionallyWith(codeLength.map(value => value: Integer))(_.codeLength)
      .destinationIdentity(destinationIdentity: java.lang.String)
      .optionallyWith(entityId.map(value => value: java.lang.String))(
        _.entityId
      )
      .optionallyWith(language.map(value => value: java.lang.String))(
        _.language
      )
      .originationIdentity(originationIdentity: java.lang.String)
      .referenceId(referenceId: java.lang.String)
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .optionallyWith(validityPeriod.map(value => value: Integer))(
        _.validityPeriod
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.SendOTPMessageRequestParameters.ReadOnly =
    zio.aws.pinpoint.model.SendOTPMessageRequestParameters.wrap(buildAwsValue())
}
object SendOTPMessageRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SendOTPMessageRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SendOTPMessageRequestParameters =
      zio.aws.pinpoint.model.SendOTPMessageRequestParameters(
        allowedAttempts.map(value => value),
        brandName,
        channel,
        codeLength.map(value => value),
        destinationIdentity,
        entityId.map(value => value),
        language.map(value => value),
        originationIdentity,
        referenceId,
        templateId.map(value => value),
        validityPeriod.map(value => value)
      )
    def allowedAttempts: Optional[__integer]
    def brandName: __string
    def channel: __string
    def codeLength: Optional[__integer]
    def destinationIdentity: __string
    def entityId: Optional[__string]
    def language: Optional[__string]
    def originationIdentity: __string
    def referenceId: __string
    def templateId: Optional[__string]
    def validityPeriod: Optional[__integer]
    def getAllowedAttempts: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("allowedAttempts", allowedAttempts)
    def getBrandName: ZIO[Any, Nothing, __string] = ZIO.succeed(brandName)
    def getChannel: ZIO[Any, Nothing, __string] = ZIO.succeed(channel)
    def getCodeLength: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("codeLength", codeLength)
    def getDestinationIdentity: ZIO[Any, Nothing, __string] =
      ZIO.succeed(destinationIdentity)
    def getEntityId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getLanguage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("language", language)
    def getOriginationIdentity: ZIO[Any, Nothing, __string] =
      ZIO.succeed(originationIdentity)
    def getReferenceId: ZIO[Any, Nothing, __string] = ZIO.succeed(referenceId)
    def getTemplateId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getValidityPeriod: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("validityPeriod", validityPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SendOTPMessageRequestParameters
  ) extends zio.aws.pinpoint.model.SendOTPMessageRequestParameters.ReadOnly {
    override val allowedAttempts: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedAttempts())
      .map(value => value: __integer)
    override val brandName: __string = impl.brandName(): __string
    override val channel: __string = impl.channel(): __string
    override val codeLength: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.codeLength())
      .map(value => value: __integer)
    override val destinationIdentity: __string =
      impl.destinationIdentity(): __string
    override val entityId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.entityId())
      .map(value => value: __string)
    override val language: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => value: __string)
    override val originationIdentity: __string =
      impl.originationIdentity(): __string
    override val referenceId: __string = impl.referenceId(): __string
    override val templateId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value => value: __string)
    override val validityPeriod: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.validityPeriod())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SendOTPMessageRequestParameters
  ): zio.aws.pinpoint.model.SendOTPMessageRequestParameters.ReadOnly =
    new Wrapper(impl)
}
