package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SegmentReference(
    id: __string,
    version: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentReference = {
    import SegmentReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentReference
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(version.map(value => value: Integer))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentReference.ReadOnly =
    zio.aws.pinpoint.model.SegmentReference.wrap(buildAwsValue())
}
object SegmentReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentReference =
      zio.aws.pinpoint.model.SegmentReference(id, version.map(value => value))
    def id: __string
    def version: Optional[__integer]
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentReference
  ) extends zio.aws.pinpoint.model.SegmentReference.ReadOnly {
    override val id: __string = impl.id(): __string
    override val version: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentReference
  ): zio.aws.pinpoint.model.SegmentReference.ReadOnly = new Wrapper(impl)
}
