package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RemoveAttributesResponse(
    attributesResource: zio.aws.pinpoint.model.AttributesResource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse = {
    import RemoveAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse
      .builder()
      .attributesResource(attributesResource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.RemoveAttributesResponse.ReadOnly =
    zio.aws.pinpoint.model.RemoveAttributesResponse.wrap(buildAwsValue())
}
object RemoveAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.RemoveAttributesResponse =
      zio.aws.pinpoint.model
        .RemoveAttributesResponse(attributesResource.asEditable)
    def attributesResource: zio.aws.pinpoint.model.AttributesResource.ReadOnly
    def getAttributesResource: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.AttributesResource.ReadOnly
    ] = ZIO.succeed(attributesResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse
  ) extends zio.aws.pinpoint.model.RemoveAttributesResponse.ReadOnly {
    override val attributesResource
        : zio.aws.pinpoint.model.AttributesResource.ReadOnly =
      zio.aws.pinpoint.model.AttributesResource.wrap(impl.attributesResource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse
  ): zio.aws.pinpoint.model.RemoveAttributesResponse.ReadOnly = new Wrapper(
    impl
  )
}
