package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait RecencyType {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.RecencyType
}
object RecencyType {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.RecencyType
  ): zio.aws.pinpoint.model.RecencyType = value match {
    case software.amazon.awssdk.services.pinpoint.model.RecencyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.RecencyType.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.pinpoint.model.RecencyType.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.RecencyType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.RecencyType =
      software.amazon.awssdk.services.pinpoint.model.RecencyType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.pinpoint.model.RecencyType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.RecencyType =
      software.amazon.awssdk.services.pinpoint.model.RecencyType.ACTIVE
  }
  case object INACTIVE extends zio.aws.pinpoint.model.RecencyType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.RecencyType =
      software.amazon.awssdk.services.pinpoint.model.RecencyType.INACTIVE
  }
}
