package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RandomSplitEntry(
    nextActivity: Optional[__string] = Optional.Absent,
    percentage: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry = {
    import RandomSplitEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry
      .builder()
      .optionallyWith(nextActivity.map(value => value: java.lang.String))(
        _.nextActivity
      )
      .optionallyWith(percentage.map(value => value: Integer))(_.percentage)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.RandomSplitEntry.ReadOnly =
    zio.aws.pinpoint.model.RandomSplitEntry.wrap(buildAwsValue())
}
object RandomSplitEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.RandomSplitEntry =
      zio.aws.pinpoint.model.RandomSplitEntry(
        nextActivity.map(value => value),
        percentage.map(value => value)
      )
    def nextActivity: Optional[__string]
    def percentage: Optional[__integer]
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
    def getPercentage: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("percentage", percentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry
  ) extends zio.aws.pinpoint.model.RandomSplitEntry.ReadOnly {
    override val nextActivity: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextActivity())
      .map(value => value: __string)
    override val percentage: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.percentage())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry
  ): zio.aws.pinpoint.model.RandomSplitEntry.ReadOnly = new Wrapper(impl)
}
