package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QuietTime(
    end: Optional[__string] = Optional.Absent,
    start: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.QuietTime = {
    import QuietTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.QuietTime
      .builder()
      .optionallyWith(end.map(value => value: java.lang.String))(_.end)
      .optionallyWith(start.map(value => value: java.lang.String))(_.start)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.QuietTime.ReadOnly =
    zio.aws.pinpoint.model.QuietTime.wrap(buildAwsValue())
}
object QuietTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.QuietTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.QuietTime = zio.aws.pinpoint.model
      .QuietTime(end.map(value => value), start.map(value => value))
    def end: Optional[__string]
    def start: Optional[__string]
    def getEnd: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("end", end)
    def getStart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("start", start)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.QuietTime
  ) extends zio.aws.pinpoint.model.QuietTime.ReadOnly {
    override val end: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => value: __string)
    override val start: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.QuietTime
  ): zio.aws.pinpoint.model.QuietTime.ReadOnly = new Wrapper(impl)
}
