package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OpenHours(
    email: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, Iterable[
      zio.aws.pinpoint.model.OpenHoursRule
    ]]] = Optional.Absent,
    sms: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, Iterable[
      zio.aws.pinpoint.model.OpenHoursRule
    ]]] = Optional.Absent,
    push: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, Iterable[
      zio.aws.pinpoint.model.OpenHoursRule
    ]]] = Optional.Absent,
    voice: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, Iterable[
      zio.aws.pinpoint.model.OpenHoursRule
    ]]] = Optional.Absent,
    custom: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, Iterable[
      zio.aws.pinpoint.model.OpenHoursRule
    ]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.OpenHours = {
    import OpenHours.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.OpenHours
      .builder()
      .optionallyWith(
        email.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.emailWithStrings)
      .optionallyWith(
        sms.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.smsWithStrings)
      .optionallyWith(
        push.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.pushWithStrings)
      .optionallyWith(
        voice.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.voiceWithStrings)
      .optionallyWith(
        custom.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.customWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.OpenHours.ReadOnly =
    zio.aws.pinpoint.model.OpenHours.wrap(buildAwsValue())
}
object OpenHours {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.OpenHours
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.OpenHours =
      zio.aws.pinpoint.model.OpenHours(
        email.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        sms.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        push.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        voice.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        custom.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        )
      )
    def email: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]]
    def sms: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]]
    def push: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]]
    def voice: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]]
    def custom: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]]
    def getEmail: ZIO[Any, AwsError, Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]] = AwsError.unwrapOptionField("email", email)
    def getSms: ZIO[Any, AwsError, Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]] = AwsError.unwrapOptionField("sms", sms)
    def getPush: ZIO[Any, AwsError, Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]] = AwsError.unwrapOptionField("push", push)
    def getVoice: ZIO[Any, AwsError, Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]] = AwsError.unwrapOptionField("voice", voice)
    def getCustom
        : ZIO[Any, AwsError, Map[zio.aws.pinpoint.model.DayOfWeek, List[
          zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
        ]]] = AwsError.unwrapOptionField("custom", custom)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.OpenHours
  ) extends zio.aws.pinpoint.model.OpenHours.ReadOnly {
    override val email: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.DayOfWeek.wrap(key) -> value.asScala.map {
              item =>
                zio.aws.pinpoint.model.OpenHoursRule.wrap(item)
            }.toList
          })
          .toMap
      )
    override val sms: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.sms())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.DayOfWeek.wrap(key) -> value.asScala.map {
              item =>
                zio.aws.pinpoint.model.OpenHoursRule.wrap(item)
            }.toList
          })
          .toMap
      )
    override val push: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.push())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.DayOfWeek.wrap(key) -> value.asScala.map {
              item =>
                zio.aws.pinpoint.model.OpenHoursRule.wrap(item)
            }.toList
          })
          .toMap
      )
    override val voice: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.voice())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.DayOfWeek.wrap(key) -> value.asScala.map {
              item =>
                zio.aws.pinpoint.model.OpenHoursRule.wrap(item)
            }.toList
          })
          .toMap
      )
    override val custom: Optional[Map[zio.aws.pinpoint.model.DayOfWeek, List[
      zio.aws.pinpoint.model.OpenHoursRule.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.custom())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.DayOfWeek.wrap(key) -> value.asScala.map {
              item =>
                zio.aws.pinpoint.model.OpenHoursRule.wrap(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.OpenHours
  ): zio.aws.pinpoint.model.OpenHours.ReadOnly = new Wrapper(impl)
}
