package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTemplatesRequest(
    nextToken: Optional[__string] = Optional.Absent,
    pageSize: Optional[__string] = Optional.Absent,
    prefix: Optional[__string] = Optional.Absent,
    templateType: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest = {
    import ListTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(pageSize.map(value => value: java.lang.String))(
        _.pageSize
      )
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(templateType.map(value => value: java.lang.String))(
        _.templateType
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ListTemplatesRequest.ReadOnly =
    zio.aws.pinpoint.model.ListTemplatesRequest.wrap(buildAwsValue())
}
object ListTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ListTemplatesRequest =
      zio.aws.pinpoint.model.ListTemplatesRequest(
        nextToken.map(value => value),
        pageSize.map(value => value),
        prefix.map(value => value),
        templateType.map(value => value)
      )
    def nextToken: Optional[__string]
    def pageSize: Optional[__string]
    def prefix: Optional[__string]
    def templateType: Optional[__string]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTemplateType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateType", templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest
  ) extends zio.aws.pinpoint.model.ListTemplatesRequest.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val pageSize: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => value: __string)
    override val prefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: __string)
    override val templateType: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateType())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest
  ): zio.aws.pinpoint.model.ListTemplatesRequest.ReadOnly = new Wrapper(impl)
}
