package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTemplateVersionsRequest(
    nextToken: Optional[__string] = Optional.Absent,
    pageSize: Optional[__string] = Optional.Absent,
    templateName: __string,
    templateType: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest = {
    import ListTemplateVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(pageSize.map(value => value: java.lang.String))(
        _.pageSize
      )
      .templateName(templateName: java.lang.String)
      .templateType(templateType: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ListTemplateVersionsRequest.ReadOnly =
    zio.aws.pinpoint.model.ListTemplateVersionsRequest.wrap(buildAwsValue())
}
object ListTemplateVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ListTemplateVersionsRequest =
      zio.aws.pinpoint.model.ListTemplateVersionsRequest(
        nextToken.map(value => value),
        pageSize.map(value => value),
        templateName,
        templateType
      )
    def nextToken: Optional[__string]
    def pageSize: Optional[__string]
    def templateName: __string
    def templateType: __string
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType: ZIO[Any, Nothing, __string] = ZIO.succeed(templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest
  ) extends zio.aws.pinpoint.model.ListTemplateVersionsRequest.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val pageSize: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => value: __string)
    override val templateName: __string = impl.templateName(): __string
    override val templateType: __string = impl.templateType(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest
  ): zio.aws.pinpoint.model.ListTemplateVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
