package zio.aws.pinpoint.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__string, __timestampIso8601}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class JourneySchedule(
    endTime: Optional[__timestampIso8601] = Optional.Absent,
    startTime: Optional[__timestampIso8601] = Optional.Absent,
    timezone: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneySchedule = {
    import JourneySchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneySchedule
      .builder()
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneySchedule.ReadOnly =
    zio.aws.pinpoint.model.JourneySchedule.wrap(buildAwsValue())
}
object JourneySchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneySchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneySchedule =
      zio.aws.pinpoint.model.JourneySchedule(
        endTime.map(value => value),
        startTime.map(value => value),
        timezone.map(value => value)
      )
    def endTime: Optional[__timestampIso8601]
    def startTime: Optional[__timestampIso8601]
    def timezone: Optional[__string]
    def getEndTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStartTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getTimezone: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timezone", timezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneySchedule
  ) extends zio.aws.pinpoint.model.JourneySchedule.ReadOnly {
    override val endTime: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: __timestampIso8601)
    override val startTime: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: __timestampIso8601)
    override val timezone: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneySchedule
  ): zio.aws.pinpoint.model.JourneySchedule.ReadOnly = new Wrapper(impl)
}
