package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait JourneyRunStatus {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus
}
object JourneyRunStatus {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus
  ): zio.aws.pinpoint.model.JourneyRunStatus = value match {
    case software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus.SCHEDULED =>
      val r = SCHEDULED
      r
    case software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpoint.model.JourneyRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus =
      software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SCHEDULED extends zio.aws.pinpoint.model.JourneyRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus =
      software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus.SCHEDULED
  }
  case object RUNNING extends zio.aws.pinpoint.model.JourneyRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus =
      software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus.RUNNING
  }
  case object COMPLETED extends zio.aws.pinpoint.model.JourneyRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus =
      software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus.COMPLETED
  }
  case object CANCELLED extends zio.aws.pinpoint.model.JourneyRunStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus =
      software.amazon.awssdk.services.pinpoint.model.JourneyRunStatus.CANCELLED
  }
}
