package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class JourneyRunExecutionMetricsResponse(
    applicationId: __string,
    journeyId: __string,
    lastEvaluatedTime: __string,
    metrics: Map[__string, __string],
    runId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyRunExecutionMetricsResponse = {
    import JourneyRunExecutionMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyRunExecutionMetricsResponse
      .builder()
      .applicationId(applicationId: java.lang.String)
      .journeyId(journeyId: java.lang.String)
      .lastEvaluatedTime(lastEvaluatedTime: java.lang.String)
      .metrics(
        metrics
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .runId(runId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.JourneyRunExecutionMetricsResponse.ReadOnly =
    zio.aws.pinpoint.model.JourneyRunExecutionMetricsResponse
      .wrap(buildAwsValue())
}
object JourneyRunExecutionMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyRunExecutionMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyRunExecutionMetricsResponse =
      zio.aws.pinpoint.model.JourneyRunExecutionMetricsResponse(
        applicationId,
        journeyId,
        lastEvaluatedTime,
        metrics,
        runId
      )
    def applicationId: __string
    def journeyId: __string
    def lastEvaluatedTime: __string
    def metrics: Map[__string, __string]
    def runId: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getLastEvaluatedTime: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastEvaluatedTime)
    def getMetrics: ZIO[Any, Nothing, Map[__string, __string]] =
      ZIO.succeed(metrics)
    def getRunId: ZIO[Any, Nothing, __string] = ZIO.succeed(runId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyRunExecutionMetricsResponse
  ) extends zio.aws.pinpoint.model.JourneyRunExecutionMetricsResponse.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val journeyId: __string = impl.journeyId(): __string
    override val lastEvaluatedTime: __string =
      impl.lastEvaluatedTime(): __string
    override val metrics: Map[__string, __string] = impl
      .metrics()
      .asScala
      .map({ case (key, value) =>
        (key: __string) -> (value: __string)
      })
      .toMap
    override val runId: __string = impl.runId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyRunExecutionMetricsResponse
  ): zio.aws.pinpoint.model.JourneyRunExecutionMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
