package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InAppTemplateResponse(
    arn: Optional[__string] = Optional.Absent,
    content: Optional[Iterable[zio.aws.pinpoint.model.InAppMessageContent]] =
      Optional.Absent,
    creationDate: __string,
    customConfig: Optional[Map[__string, __string]] = Optional.Absent,
    lastModifiedDate: __string,
    layout: Optional[zio.aws.pinpoint.model.Layout] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    templateDescription: Optional[__string] = Optional.Absent,
    templateName: __string,
    templateType: zio.aws.pinpoint.model.TemplateType,
    version: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppTemplateResponse = {
    import InAppTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppTemplateResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        content.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.content)
      .creationDate(creationDate: java.lang.String)
      .optionallyWith(
        customConfig.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.customConfig)
      .lastModifiedDate(lastModifiedDate: java.lang.String)
      .optionallyWith(layout.map(value => value.unwrap))(_.layout)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value => value: java.lang.String)
      )(_.templateDescription)
      .templateName(templateName: java.lang.String)
      .templateType(templateType.unwrap)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppTemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.InAppTemplateResponse.wrap(buildAwsValue())
}
object InAppTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppTemplateResponse =
      zio.aws.pinpoint.model.InAppTemplateResponse(
        arn.map(value => value),
        content.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationDate,
        customConfig.map(value => value),
        lastModifiedDate,
        layout.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value),
        templateName,
        templateType,
        version.map(value => value)
      )
    def arn: Optional[__string]
    def content
        : Optional[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]]
    def creationDate: __string
    def customConfig: Optional[Map[__string, __string]]
    def lastModifiedDate: __string
    def layout: Optional[zio.aws.pinpoint.model.Layout]
    def tags: Optional[Map[__string, __string]]
    def templateDescription: Optional[__string]
    def templateName: __string
    def templateType: zio.aws.pinpoint.model.TemplateType
    def version: Optional[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getContent: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.InAppMessageContent.ReadOnly
    ]] = AwsError.unwrapOptionField("content", content)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getCustomConfig: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("customConfig", customConfig)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getLayout: ZIO[Any, AwsError, zio.aws.pinpoint.model.Layout] =
      AwsError.unwrapOptionField("layout", layout)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.TemplateType] =
      ZIO.succeed(templateType)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppTemplateResponse
  ) extends zio.aws.pinpoint.model.InAppTemplateResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val content
        : Optional[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.content())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.InAppMessageContent.wrap(item)
          }.toList
        )
    override val creationDate: __string = impl.creationDate(): __string
    override val customConfig: Optional[Map[__string, __string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customConfig())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __string)
            })
            .toMap
        )
    override val lastModifiedDate: __string = impl.lastModifiedDate(): __string
    override val layout: Optional[zio.aws.pinpoint.model.Layout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layout())
        .map(value => zio.aws.pinpoint.model.Layout.wrap(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val templateDescription: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateDescription())
      .map(value => value: __string)
    override val templateName: __string = impl.templateName(): __string
    override val templateType: zio.aws.pinpoint.model.TemplateType =
      zio.aws.pinpoint.model.TemplateType.wrap(impl.templateType())
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppTemplateResponse
  ): zio.aws.pinpoint.model.InAppTemplateResponse.ReadOnly = new Wrapper(impl)
}
