package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class InAppMessageCampaign(
    campaignId: Optional[__string] = Optional.Absent,
    dailyCap: Optional[__integer] = Optional.Absent,
    inAppMessage: Optional[zio.aws.pinpoint.model.InAppMessage] =
      Optional.Absent,
    priority: Optional[__integer] = Optional.Absent,
    schedule: Optional[zio.aws.pinpoint.model.InAppCampaignSchedule] =
      Optional.Absent,
    sessionCap: Optional[__integer] = Optional.Absent,
    totalCap: Optional[__integer] = Optional.Absent,
    treatmentId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign = {
    import InAppMessageCampaign.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign
      .builder()
      .optionallyWith(campaignId.map(value => value: java.lang.String))(
        _.campaignId
      )
      .optionallyWith(dailyCap.map(value => value: Integer))(_.dailyCap)
      .optionallyWith(inAppMessage.map(value => value.buildAwsValue()))(
        _.inAppMessage
      )
      .optionallyWith(priority.map(value => value: Integer))(_.priority)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(sessionCap.map(value => value: Integer))(_.sessionCap)
      .optionallyWith(totalCap.map(value => value: Integer))(_.totalCap)
      .optionallyWith(treatmentId.map(value => value: java.lang.String))(
        _.treatmentId
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppMessageCampaign.ReadOnly =
    zio.aws.pinpoint.model.InAppMessageCampaign.wrap(buildAwsValue())
}
object InAppMessageCampaign {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppMessageCampaign =
      zio.aws.pinpoint.model.InAppMessageCampaign(
        campaignId.map(value => value),
        dailyCap.map(value => value),
        inAppMessage.map(value => value.asEditable),
        priority.map(value => value),
        schedule.map(value => value.asEditable),
        sessionCap.map(value => value),
        totalCap.map(value => value),
        treatmentId.map(value => value)
      )
    def campaignId: Optional[__string]
    def dailyCap: Optional[__integer]
    def inAppMessage: Optional[zio.aws.pinpoint.model.InAppMessage.ReadOnly]
    def priority: Optional[__integer]
    def schedule
        : Optional[zio.aws.pinpoint.model.InAppCampaignSchedule.ReadOnly]
    def sessionCap: Optional[__integer]
    def totalCap: Optional[__integer]
    def treatmentId: Optional[__string]
    def getCampaignId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("campaignId", campaignId)
    def getDailyCap: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("dailyCap", dailyCap)
    def getInAppMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.InAppMessage.ReadOnly] =
      AwsError.unwrapOptionField("inAppMessage", inAppMessage)
    def getPriority: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.InAppCampaignSchedule.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getSessionCap: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("sessionCap", sessionCap)
    def getTotalCap: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("totalCap", totalCap)
    def getTreatmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentId", treatmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign
  ) extends zio.aws.pinpoint.model.InAppMessageCampaign.ReadOnly {
    override val campaignId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.campaignId())
      .map(value => value: __string)
    override val dailyCap: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dailyCap())
      .map(value => value: __integer)
    override val inAppMessage
        : Optional[zio.aws.pinpoint.model.InAppMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inAppMessage())
        .map(value => zio.aws.pinpoint.model.InAppMessage.wrap(value))
    override val priority: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: __integer)
    override val schedule
        : Optional[zio.aws.pinpoint.model.InAppCampaignSchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.pinpoint.model.InAppCampaignSchedule.wrap(value))
    override val sessionCap: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionCap())
      .map(value => value: __integer)
    override val totalCap: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCap())
      .map(value => value: __integer)
    override val treatmentId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.treatmentId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign
  ): zio.aws.pinpoint.model.InAppMessageCampaign.ReadOnly = new Wrapper(impl)
}
