package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class InAppMessageBodyConfig(
    alignment: zio.aws.pinpoint.model.Alignment,
    body: __string,
    textColor: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppMessageBodyConfig = {
    import InAppMessageBodyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppMessageBodyConfig
      .builder()
      .alignment(alignment.unwrap)
      .body(body: java.lang.String)
      .textColor(textColor: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppMessageBodyConfig.ReadOnly =
    zio.aws.pinpoint.model.InAppMessageBodyConfig.wrap(buildAwsValue())
}
object InAppMessageBodyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppMessageBodyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppMessageBodyConfig =
      zio.aws.pinpoint.model.InAppMessageBodyConfig(alignment, body, textColor)
    def alignment: zio.aws.pinpoint.model.Alignment
    def body: __string
    def textColor: __string
    def getAlignment: ZIO[Any, Nothing, zio.aws.pinpoint.model.Alignment] =
      ZIO.succeed(alignment)
    def getBody: ZIO[Any, Nothing, __string] = ZIO.succeed(body)
    def getTextColor: ZIO[Any, Nothing, __string] = ZIO.succeed(textColor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageBodyConfig
  ) extends zio.aws.pinpoint.model.InAppMessageBodyConfig.ReadOnly {
    override val alignment: zio.aws.pinpoint.model.Alignment =
      zio.aws.pinpoint.model.Alignment.wrap(impl.alignment())
    override val body: __string = impl.body(): __string
    override val textColor: __string = impl.textColor(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageBodyConfig
  ): zio.aws.pinpoint.model.InAppMessageBodyConfig.ReadOnly = new Wrapper(impl)
}
