package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ImportJobResponse(
    applicationId: __string,
    completedPieces: Optional[__integer] = Optional.Absent,
    completionDate: Optional[__string] = Optional.Absent,
    creationDate: __string,
    definition: zio.aws.pinpoint.model.ImportJobResource,
    failedPieces: Optional[__integer] = Optional.Absent,
    failures: Optional[Iterable[__string]] = Optional.Absent,
    id: __string,
    jobStatus: zio.aws.pinpoint.model.JobStatus,
    totalFailures: Optional[__integer] = Optional.Absent,
    totalPieces: Optional[__integer] = Optional.Absent,
    totalProcessed: Optional[__integer] = Optional.Absent,
    `type`: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ImportJobResponse = {
    import ImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ImportJobResponse
      .builder()
      .applicationId(applicationId: java.lang.String)
      .optionallyWith(completedPieces.map(value => value: Integer))(
        _.completedPieces
      )
      .optionallyWith(completionDate.map(value => value: java.lang.String))(
        _.completionDate
      )
      .creationDate(creationDate: java.lang.String)
      .definition(definition.buildAwsValue())
      .optionallyWith(failedPieces.map(value => value: Integer))(_.failedPieces)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.failures)
      .id(id: java.lang.String)
      .jobStatus(jobStatus.unwrap)
      .optionallyWith(totalFailures.map(value => value: Integer))(
        _.totalFailures
      )
      .optionallyWith(totalPieces.map(value => value: Integer))(_.totalPieces)
      .optionallyWith(totalProcessed.map(value => value: Integer))(
        _.totalProcessed
      )
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ImportJobResponse.ReadOnly =
    zio.aws.pinpoint.model.ImportJobResponse.wrap(buildAwsValue())
}
object ImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ImportJobResponse =
      zio.aws.pinpoint.model.ImportJobResponse(
        applicationId,
        completedPieces.map(value => value),
        completionDate.map(value => value),
        creationDate,
        definition.asEditable,
        failedPieces.map(value => value),
        failures.map(value => value),
        id,
        jobStatus,
        totalFailures.map(value => value),
        totalPieces.map(value => value),
        totalProcessed.map(value => value),
        `type`
      )
    def applicationId: __string
    def completedPieces: Optional[__integer]
    def completionDate: Optional[__string]
    def creationDate: __string
    def definition: zio.aws.pinpoint.model.ImportJobResource.ReadOnly
    def failedPieces: Optional[__integer]
    def failures: Optional[List[__string]]
    def id: __string
    def jobStatus: zio.aws.pinpoint.model.JobStatus
    def totalFailures: Optional[__integer]
    def totalPieces: Optional[__integer]
    def totalProcessed: Optional[__integer]
    def `type`: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCompletedPieces: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("completedPieces", completedPieces)
    def getCompletionDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDefinition
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.ImportJobResource.ReadOnly] =
      ZIO.succeed(definition)
    def getFailedPieces: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("failedPieces", failedPieces)
    def getFailures: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("failures", failures)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getJobStatus: ZIO[Any, Nothing, zio.aws.pinpoint.model.JobStatus] =
      ZIO.succeed(jobStatus)
    def getTotalFailures: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("totalFailures", totalFailures)
    def getTotalPieces: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("totalPieces", totalPieces)
    def getTotalProcessed: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("totalProcessed", totalProcessed)
    def getType: ZIO[Any, Nothing, __string] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ImportJobResponse
  ) extends zio.aws.pinpoint.model.ImportJobResponse.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val completedPieces: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.completedPieces())
      .map(value => value: __integer)
    override val completionDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.completionDate())
      .map(value => value: __string)
    override val creationDate: __string = impl.creationDate(): __string
    override val definition: zio.aws.pinpoint.model.ImportJobResource.ReadOnly =
      zio.aws.pinpoint.model.ImportJobResource.wrap(impl.definition())
    override val failedPieces: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedPieces())
      .map(value => value: __integer)
    override val failures: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.failures())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val id: __string = impl.id(): __string
    override val jobStatus: zio.aws.pinpoint.model.JobStatus =
      zio.aws.pinpoint.model.JobStatus.wrap(impl.jobStatus())
    override val totalFailures: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalFailures())
      .map(value => value: __integer)
    override val totalPieces: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalPieces())
      .map(value => value: __integer)
    override val totalProcessed: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalProcessed())
      .map(value => value: __integer)
    override val `type`: __string = impl.`type`(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ImportJobResponse
  ): zio.aws.pinpoint.model.ImportJobResponse.ReadOnly = new Wrapper(impl)
}
