package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetJourneyExecutionMetricsRequest(
    applicationId: __string,
    journeyId: __string,
    nextToken: Optional[__string] = Optional.Absent,
    pageSize: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest = {
    import GetJourneyExecutionMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .journeyId(journeyId: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(pageSize.map(value => value: java.lang.String))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest.ReadOnly =
    zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest
      .wrap(buildAwsValue())
}
object GetJourneyExecutionMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest =
      zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest(
        applicationId,
        journeyId,
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def applicationId: __string
    def journeyId: __string
    def nextToken: Optional[__string]
    def pageSize: Optional[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest
  ) extends zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val journeyId: __string = impl.journeyId(): __string
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val pageSize: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest
  ): zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
