package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEventStreamResponse(
    eventStream: zio.aws.pinpoint.model.EventStream
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse = {
    import GetEventStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse
      .builder()
      .eventStream(eventStream.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetEventStreamResponse.ReadOnly =
    zio.aws.pinpoint.model.GetEventStreamResponse.wrap(buildAwsValue())
}
object GetEventStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetEventStreamResponse =
      zio.aws.pinpoint.model.GetEventStreamResponse(eventStream.asEditable)
    def eventStream: zio.aws.pinpoint.model.EventStream.ReadOnly
    def getEventStream
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.EventStream.ReadOnly] =
      ZIO.succeed(eventStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse
  ) extends zio.aws.pinpoint.model.GetEventStreamResponse.ReadOnly {
    override val eventStream: zio.aws.pinpoint.model.EventStream.ReadOnly =
      zio.aws.pinpoint.model.EventStream.wrap(impl.eventStream())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse
  ): zio.aws.pinpoint.model.GetEventStreamResponse.ReadOnly = new Wrapper(impl)
}
