package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEmailChannelResponse(
    emailChannelResponse: zio.aws.pinpoint.model.EmailChannelResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse = {
    import GetEmailChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse
      .builder()
      .emailChannelResponse(emailChannelResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetEmailChannelResponse.ReadOnly =
    zio.aws.pinpoint.model.GetEmailChannelResponse.wrap(buildAwsValue())
}
object GetEmailChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetEmailChannelResponse =
      zio.aws.pinpoint.model
        .GetEmailChannelResponse(emailChannelResponse.asEditable)
    def emailChannelResponse
        : zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly
    def getEmailChannelResponse: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly
    ] = ZIO.succeed(emailChannelResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse
  ) extends zio.aws.pinpoint.model.GetEmailChannelResponse.ReadOnly {
    override val emailChannelResponse
        : zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly =
      zio.aws.pinpoint.model.EmailChannelResponse
        .wrap(impl.emailChannelResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse
  ): zio.aws.pinpoint.model.GetEmailChannelResponse.ReadOnly = new Wrapper(impl)
}
