package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAppsRequest(
    pageSize: Optional[__string] = Optional.Absent,
    token: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetAppsRequest = {
    import GetAppsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetAppsRequest
      .builder()
      .optionallyWith(pageSize.map(value => value: java.lang.String))(
        _.pageSize
      )
      .optionallyWith(token.map(value => value: java.lang.String))(_.token)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetAppsRequest.ReadOnly =
    zio.aws.pinpoint.model.GetAppsRequest.wrap(buildAwsValue())
}
object GetAppsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetAppsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetAppsRequest =
      zio.aws.pinpoint.model
        .GetAppsRequest(pageSize.map(value => value), token.map(value => value))
    def pageSize: Optional[__string]
    def token: Optional[__string]
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("token", token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetAppsRequest
  ) extends zio.aws.pinpoint.model.GetAppsRequest.ReadOnly {
    override val pageSize: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => value: __string)
    override val token: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.token())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetAppsRequest
  ): zio.aws.pinpoint.model.GetAppsRequest.ReadOnly = new Wrapper(impl)
}
