package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAppResponse(
    applicationResponse: zio.aws.pinpoint.model.ApplicationResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetAppResponse = {
    import GetAppResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetAppResponse
      .builder()
      .applicationResponse(applicationResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetAppResponse.ReadOnly =
    zio.aws.pinpoint.model.GetAppResponse.wrap(buildAwsValue())
}
object GetAppResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetAppResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetAppResponse =
      zio.aws.pinpoint.model.GetAppResponse(applicationResponse.asEditable)
    def applicationResponse: zio.aws.pinpoint.model.ApplicationResponse.ReadOnly
    def getApplicationResponse: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.ApplicationResponse.ReadOnly
    ] = ZIO.succeed(applicationResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetAppResponse
  ) extends zio.aws.pinpoint.model.GetAppResponse.ReadOnly {
    override val applicationResponse
        : zio.aws.pinpoint.model.ApplicationResponse.ReadOnly =
      zio.aws.pinpoint.model.ApplicationResponse
        .wrap(impl.applicationResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetAppResponse
  ): zio.aws.pinpoint.model.GetAppResponse.ReadOnly = new Wrapper(impl)
}
