package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait Frequency {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.Frequency
}
object Frequency {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.Frequency
  ): zio.aws.pinpoint.model.Frequency = value match {
    case software.amazon.awssdk.services.pinpoint.model.Frequency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.Frequency.ONCE =>
      val r = ONCE
      r
    case software.amazon.awssdk.services.pinpoint.model.Frequency.HOURLY =>
      val r = HOURLY
      r
    case software.amazon.awssdk.services.pinpoint.model.Frequency.DAILY =>
      val r = DAILY
      r
    case software.amazon.awssdk.services.pinpoint.model.Frequency.WEEKLY =>
      val r = WEEKLY
      r
    case software.amazon.awssdk.services.pinpoint.model.Frequency.MONTHLY =>
      val r = MONTHLY
      r
    case software.amazon.awssdk.services.pinpoint.model.Frequency.EVENT =>
      val r = EVENT
      r
    case software.amazon.awssdk.services.pinpoint.model.Frequency.IN_APP_EVENT =>
      val r = IN_APP_EVENT
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.Frequency {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Frequency =
      software.amazon.awssdk.services.pinpoint.model.Frequency.UNKNOWN_TO_SDK_VERSION
  }
  case object ONCE extends zio.aws.pinpoint.model.Frequency {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Frequency =
      software.amazon.awssdk.services.pinpoint.model.Frequency.ONCE
  }
  case object HOURLY extends zio.aws.pinpoint.model.Frequency {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Frequency =
      software.amazon.awssdk.services.pinpoint.model.Frequency.HOURLY
  }
  case object DAILY extends zio.aws.pinpoint.model.Frequency {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Frequency =
      software.amazon.awssdk.services.pinpoint.model.Frequency.DAILY
  }
  case object WEEKLY extends zio.aws.pinpoint.model.Frequency {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Frequency =
      software.amazon.awssdk.services.pinpoint.model.Frequency.WEEKLY
  }
  case object MONTHLY extends zio.aws.pinpoint.model.Frequency {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Frequency =
      software.amazon.awssdk.services.pinpoint.model.Frequency.MONTHLY
  }
  case object EVENT extends zio.aws.pinpoint.model.Frequency {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Frequency =
      software.amazon.awssdk.services.pinpoint.model.Frequency.EVENT
  }
  case object IN_APP_EVENT extends zio.aws.pinpoint.model.Frequency {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Frequency =
      software.amazon.awssdk.services.pinpoint.model.Frequency.IN_APP_EVENT
  }
}
