package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait Format {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.Format
}
object Format {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.Format
  ): zio.aws.pinpoint.model.Format = value match {
    case software.amazon.awssdk.services.pinpoint.model.Format.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.Format.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.pinpoint.model.Format.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.Format {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Format =
      software.amazon.awssdk.services.pinpoint.model.Format.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.pinpoint.model.Format {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Format =
      software.amazon.awssdk.services.pinpoint.model.Format.CSV
  }
  case object JSON extends zio.aws.pinpoint.model.Format {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Format =
      software.amazon.awssdk.services.pinpoint.model.Format.JSON
  }
}
