package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventsResponse(
    results: Optional[Map[__string, zio.aws.pinpoint.model.ItemResponse]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventsResponse = {
    import EventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventsResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.results)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventsResponse.ReadOnly =
    zio.aws.pinpoint.model.EventsResponse.wrap(buildAwsValue())
}
object EventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventsResponse =
      zio.aws.pinpoint.model.EventsResponse(
        results.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def results
        : Optional[Map[__string, zio.aws.pinpoint.model.ItemResponse.ReadOnly]]
    def getResults: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.ItemResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventsResponse
  ) extends zio.aws.pinpoint.model.EventsResponse.ReadOnly {
    override val results: Optional[
      Map[__string, zio.aws.pinpoint.model.ItemResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.results())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.pinpoint.model.ItemResponse.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventsResponse
  ): zio.aws.pinpoint.model.EventsResponse.ReadOnly = new Wrapper(impl)
}
