package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventStream(
    applicationId: __string,
    destinationStreamArn: __string,
    externalId: Optional[__string] = Optional.Absent,
    lastModifiedDate: Optional[__string] = Optional.Absent,
    lastUpdatedBy: Optional[__string] = Optional.Absent,
    roleArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventStream = {
    import EventStream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventStream
      .builder()
      .applicationId(applicationId: java.lang.String)
      .destinationStreamArn(destinationStreamArn: java.lang.String)
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.String))(
        _.lastModifiedDate
      )
      .optionallyWith(lastUpdatedBy.map(value => value: java.lang.String))(
        _.lastUpdatedBy
      )
      .roleArn(roleArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventStream.ReadOnly =
    zio.aws.pinpoint.model.EventStream.wrap(buildAwsValue())
}
object EventStream {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventStream
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventStream =
      zio.aws.pinpoint.model.EventStream(
        applicationId,
        destinationStreamArn,
        externalId.map(value => value),
        lastModifiedDate.map(value => value),
        lastUpdatedBy.map(value => value),
        roleArn
      )
    def applicationId: __string
    def destinationStreamArn: __string
    def externalId: Optional[__string]
    def lastModifiedDate: Optional[__string]
    def lastUpdatedBy: Optional[__string]
    def roleArn: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getDestinationStreamArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(destinationStreamArn)
    def getExternalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastUpdatedBy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventStream
  ) extends zio.aws.pinpoint.model.EventStream.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val destinationStreamArn: __string =
      impl.destinationStreamArn(): __string
    override val externalId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => value: __string)
    override val lastModifiedDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: __string)
    override val lastUpdatedBy: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedBy())
      .map(value => value: __string)
    override val roleArn: __string = impl.roleArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventStream
  ): zio.aws.pinpoint.model.EventStream.ReadOnly = new Wrapper(impl)
}
