package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventStartCondition(
    eventFilter: Optional[zio.aws.pinpoint.model.EventFilter] = Optional.Absent,
    segmentId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventStartCondition = {
    import EventStartCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventStartCondition
      .builder()
      .optionallyWith(eventFilter.map(value => value.buildAwsValue()))(
        _.eventFilter
      )
      .optionallyWith(segmentId.map(value => value: java.lang.String))(
        _.segmentId
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventStartCondition.ReadOnly =
    zio.aws.pinpoint.model.EventStartCondition.wrap(buildAwsValue())
}
object EventStartCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventStartCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventStartCondition =
      zio.aws.pinpoint.model.EventStartCondition(
        eventFilter.map(value => value.asEditable),
        segmentId.map(value => value)
      )
    def eventFilter: Optional[zio.aws.pinpoint.model.EventFilter.ReadOnly]
    def segmentId: Optional[__string]
    def getEventFilter
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.EventFilter.ReadOnly] =
      AwsError.unwrapOptionField("eventFilter", eventFilter)
    def getSegmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentId", segmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventStartCondition
  ) extends zio.aws.pinpoint.model.EventStartCondition.ReadOnly {
    override val eventFilter
        : Optional[zio.aws.pinpoint.model.EventFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventFilter())
        .map(value => zio.aws.pinpoint.model.EventFilter.wrap(value))
    override val segmentId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventStartCondition
  ): zio.aws.pinpoint.model.EventStartCondition.ReadOnly = new Wrapper(impl)
}
