package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventDimensions(
    attributes: Optional[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension]
    ] = Optional.Absent,
    eventType: Optional[zio.aws.pinpoint.model.SetDimension] = Optional.Absent,
    metrics: Optional[Map[__string, zio.aws.pinpoint.model.MetricDimension]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventDimensions = {
    import EventDimensions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventDimensions
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(eventType.map(value => value.buildAwsValue()))(
        _.eventType
      )
      .optionallyWith(
        metrics.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.metrics)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventDimensions.ReadOnly =
    zio.aws.pinpoint.model.EventDimensions.wrap(buildAwsValue())
}
object EventDimensions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventDimensions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventDimensions =
      zio.aws.pinpoint.model.EventDimensions(
        attributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        eventType.map(value => value.asEditable),
        metrics.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def attributes: Optional[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension.ReadOnly]
    ]
    def eventType: Optional[zio.aws.pinpoint.model.SetDimension.ReadOnly]
    def metrics: Optional[
      Map[__string, zio.aws.pinpoint.model.MetricDimension.ReadOnly]
    ]
    def getAttributes: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.AttributeDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getEventType
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getMetrics: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.MetricDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventDimensions
  ) extends zio.aws.pinpoint.model.EventDimensions.ReadOnly {
    override val attributes: Optional[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.pinpoint.model.AttributeDimension
              .wrap(value)
          })
          .toMap
      )
    override val eventType
        : Optional[zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventType())
        .map(value => zio.aws.pinpoint.model.SetDimension.wrap(value))
    override val metrics: Optional[
      Map[__string, zio.aws.pinpoint.model.MetricDimension.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metrics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.pinpoint.model.MetricDimension
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventDimensions
  ): zio.aws.pinpoint.model.EventDimensions.ReadOnly = new Wrapper(impl)
}
