package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EndpointsResponse(
    item: Iterable[zio.aws.pinpoint.model.EndpointResponse]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointsResponse = {
    import EndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointsResponse
      .builder()
      .item(item.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointsResponse.ReadOnly =
    zio.aws.pinpoint.model.EndpointsResponse.wrap(buildAwsValue())
}
object EndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointsResponse =
      zio.aws.pinpoint.model.EndpointsResponse(item.map { item =>
        item.asEditable
      })
    def item: List[zio.aws.pinpoint.model.EndpointResponse.ReadOnly]
    def getItem: ZIO[Any, Nothing, List[
      zio.aws.pinpoint.model.EndpointResponse.ReadOnly
    ]] = ZIO.succeed(item)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointsResponse
  ) extends zio.aws.pinpoint.model.EndpointsResponse.ReadOnly {
    override val item: List[zio.aws.pinpoint.model.EndpointResponse.ReadOnly] =
      impl
        .item()
        .asScala
        .map { item =>
          zio.aws.pinpoint.model.EndpointResponse.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointsResponse
  ): zio.aws.pinpoint.model.EndpointsResponse.ReadOnly = new Wrapper(impl)
}
