package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EndpointMessageResult(
    address: Optional[__string] = Optional.Absent,
    deliveryStatus: zio.aws.pinpoint.model.DeliveryStatus,
    messageId: Optional[__string] = Optional.Absent,
    statusCode: __integer,
    statusMessage: Optional[__string] = Optional.Absent,
    updatedToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointMessageResult = {
    import EndpointMessageResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointMessageResult
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .deliveryStatus(deliveryStatus.unwrap)
      .optionallyWith(messageId.map(value => value: java.lang.String))(
        _.messageId
      )
      .statusCode(statusCode: Integer)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(updatedToken.map(value => value: java.lang.String))(
        _.updatedToken
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointMessageResult.ReadOnly =
    zio.aws.pinpoint.model.EndpointMessageResult.wrap(buildAwsValue())
}
object EndpointMessageResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointMessageResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointMessageResult =
      zio.aws.pinpoint.model.EndpointMessageResult(
        address.map(value => value),
        deliveryStatus,
        messageId.map(value => value),
        statusCode,
        statusMessage.map(value => value),
        updatedToken.map(value => value)
      )
    def address: Optional[__string]
    def deliveryStatus: zio.aws.pinpoint.model.DeliveryStatus
    def messageId: Optional[__string]
    def statusCode: __integer
    def statusMessage: Optional[__string]
    def updatedToken: Optional[__string]
    def getAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("address", address)
    def getDeliveryStatus
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.DeliveryStatus] =
      ZIO.succeed(deliveryStatus)
    def getMessageId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getStatusCode: ZIO[Any, Nothing, __integer] = ZIO.succeed(statusCode)
    def getStatusMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getUpdatedToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("updatedToken", updatedToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointMessageResult
  ) extends zio.aws.pinpoint.model.EndpointMessageResult.ReadOnly {
    override val address: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => value: __string)
    override val deliveryStatus: zio.aws.pinpoint.model.DeliveryStatus =
      zio.aws.pinpoint.model.DeliveryStatus.wrap(impl.deliveryStatus())
    override val messageId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => value: __string)
    override val statusCode: __integer = impl.statusCode(): __integer
    override val statusMessage: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: __string)
    override val updatedToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointMessageResult
  ): zio.aws.pinpoint.model.EndpointMessageResult.ReadOnly = new Wrapper(impl)
}
