package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EndpointDemographic(
    appVersion: Optional[__string] = Optional.Absent,
    locale: Optional[__string] = Optional.Absent,
    make: Optional[__string] = Optional.Absent,
    model: Optional[__string] = Optional.Absent,
    modelVersion: Optional[__string] = Optional.Absent,
    platform: Optional[__string] = Optional.Absent,
    platformVersion: Optional[__string] = Optional.Absent,
    timezone: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointDemographic = {
    import EndpointDemographic.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointDemographic
      .builder()
      .optionallyWith(appVersion.map(value => value: java.lang.String))(
        _.appVersion
      )
      .optionallyWith(locale.map(value => value: java.lang.String))(_.locale)
      .optionallyWith(make.map(value => value: java.lang.String))(_.make)
      .optionallyWith(model.map(value => value: java.lang.String))(_.model)
      .optionallyWith(modelVersion.map(value => value: java.lang.String))(
        _.modelVersion
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointDemographic.ReadOnly =
    zio.aws.pinpoint.model.EndpointDemographic.wrap(buildAwsValue())
}
object EndpointDemographic {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointDemographic
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointDemographic =
      zio.aws.pinpoint.model.EndpointDemographic(
        appVersion.map(value => value),
        locale.map(value => value),
        make.map(value => value),
        model.map(value => value),
        modelVersion.map(value => value),
        platform.map(value => value),
        platformVersion.map(value => value),
        timezone.map(value => value)
      )
    def appVersion: Optional[__string]
    def locale: Optional[__string]
    def make: Optional[__string]
    def model: Optional[__string]
    def modelVersion: Optional[__string]
    def platform: Optional[__string]
    def platformVersion: Optional[__string]
    def timezone: Optional[__string]
    def getAppVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appVersion", appVersion)
    def getLocale: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("locale", locale)
    def getMake: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("make", make)
    def getModel: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("model", model)
    def getModelVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getPlatform: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("platform", platform)
    def getPlatformVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getTimezone: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timezone", timezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointDemographic
  ) extends zio.aws.pinpoint.model.EndpointDemographic.ReadOnly {
    override val appVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.appVersion())
      .map(value => value: __string)
    override val locale: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => value: __string)
    override val make: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.make())
      .map(value => value: __string)
    override val model: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.model())
      .map(value => value: __string)
    override val modelVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersion())
      .map(value => value: __string)
    override val platform: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: __string)
    override val platformVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: __string)
    override val timezone: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointDemographic
  ): zio.aws.pinpoint.model.EndpointDemographic.ReadOnly = new Wrapper(impl)
}
