package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EmailChannelRequest(
    configurationSet: Optional[__string] = Optional.Absent,
    enabled: Optional[__boolean] = Optional.Absent,
    fromAddress: __string,
    identity: __string,
    roleArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest = {
    import EmailChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest
      .builder()
      .optionallyWith(configurationSet.map(value => value: java.lang.String))(
        _.configurationSet
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .fromAddress(fromAddress: java.lang.String)
      .identity(identity: java.lang.String)
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EmailChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.EmailChannelRequest.wrap(buildAwsValue())
}
object EmailChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EmailChannelRequest =
      zio.aws.pinpoint.model.EmailChannelRequest(
        configurationSet.map(value => value),
        enabled.map(value => value),
        fromAddress,
        identity,
        roleArn.map(value => value)
      )
    def configurationSet: Optional[__string]
    def enabled: Optional[__boolean]
    def fromAddress: __string
    def identity: __string
    def roleArn: Optional[__string]
    def getConfigurationSet: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("configurationSet", configurationSet)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getFromAddress: ZIO[Any, Nothing, __string] = ZIO.succeed(fromAddress)
    def getIdentity: ZIO[Any, Nothing, __string] = ZIO.succeed(identity)
    def getRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest
  ) extends zio.aws.pinpoint.model.EmailChannelRequest.ReadOnly {
    override val configurationSet: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSet())
      .map(value => value: __string)
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
    override val fromAddress: __string = impl.fromAddress(): __string
    override val identity: __string = impl.identity(): __string
    override val roleArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest
  ): zio.aws.pinpoint.model.EmailChannelRequest.ReadOnly = new Wrapper(impl)
}
