package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSegmentResponse(
    segmentResponse: zio.aws.pinpoint.model.SegmentResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse = {
    import DeleteSegmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse
      .builder()
      .segmentResponse(segmentResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteSegmentResponse.ReadOnly =
    zio.aws.pinpoint.model.DeleteSegmentResponse.wrap(buildAwsValue())
}
object DeleteSegmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteSegmentResponse =
      zio.aws.pinpoint.model.DeleteSegmentResponse(segmentResponse.asEditable)
    def segmentResponse: zio.aws.pinpoint.model.SegmentResponse.ReadOnly
    def getSegmentResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.SegmentResponse.ReadOnly] =
      ZIO.succeed(segmentResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse
  ) extends zio.aws.pinpoint.model.DeleteSegmentResponse.ReadOnly {
    override val segmentResponse
        : zio.aws.pinpoint.model.SegmentResponse.ReadOnly =
      zio.aws.pinpoint.model.SegmentResponse.wrap(impl.segmentResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse
  ): zio.aws.pinpoint.model.DeleteSegmentResponse.ReadOnly = new Wrapper(impl)
}
