package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteJourneyResponse(
    journeyResponse: zio.aws.pinpoint.model.JourneyResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteJourneyResponse = {
    import DeleteJourneyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteJourneyResponse
      .builder()
      .journeyResponse(journeyResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteJourneyResponse.ReadOnly =
    zio.aws.pinpoint.model.DeleteJourneyResponse.wrap(buildAwsValue())
}
object DeleteJourneyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteJourneyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteJourneyResponse =
      zio.aws.pinpoint.model.DeleteJourneyResponse(journeyResponse.asEditable)
    def journeyResponse: zio.aws.pinpoint.model.JourneyResponse.ReadOnly
    def getJourneyResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.JourneyResponse.ReadOnly] =
      ZIO.succeed(journeyResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteJourneyResponse
  ) extends zio.aws.pinpoint.model.DeleteJourneyResponse.ReadOnly {
    override val journeyResponse
        : zio.aws.pinpoint.model.JourneyResponse.ReadOnly =
      zio.aws.pinpoint.model.JourneyResponse.wrap(impl.journeyResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteJourneyResponse
  ): zio.aws.pinpoint.model.DeleteJourneyResponse.ReadOnly = new Wrapper(impl)
}
