package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateSegmentResponse(
    segmentResponse: zio.aws.pinpoint.model.SegmentResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse = {
    import CreateSegmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse
      .builder()
      .segmentResponse(segmentResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateSegmentResponse.ReadOnly =
    zio.aws.pinpoint.model.CreateSegmentResponse.wrap(buildAwsValue())
}
object CreateSegmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateSegmentResponse =
      zio.aws.pinpoint.model.CreateSegmentResponse(segmentResponse.asEditable)
    def segmentResponse: zio.aws.pinpoint.model.SegmentResponse.ReadOnly
    def getSegmentResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.SegmentResponse.ReadOnly] =
      ZIO.succeed(segmentResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse
  ) extends zio.aws.pinpoint.model.CreateSegmentResponse.ReadOnly {
    override val segmentResponse
        : zio.aws.pinpoint.model.SegmentResponse.ReadOnly =
      zio.aws.pinpoint.model.SegmentResponse.wrap(impl.segmentResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse
  ): zio.aws.pinpoint.model.CreateSegmentResponse.ReadOnly = new Wrapper(impl)
}
