package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateSegmentRequest(
    applicationId: __string,
    writeSegmentRequest: zio.aws.pinpoint.model.WriteSegmentRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest = {
    import CreateSegmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .writeSegmentRequest(writeSegmentRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateSegmentRequest.ReadOnly =
    zio.aws.pinpoint.model.CreateSegmentRequest.wrap(buildAwsValue())
}
object CreateSegmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateSegmentRequest =
      zio.aws.pinpoint.model
        .CreateSegmentRequest(applicationId, writeSegmentRequest.asEditable)
    def applicationId: __string
    def writeSegmentRequest: zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getWriteSegmentRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly
    ] = ZIO.succeed(writeSegmentRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest
  ) extends zio.aws.pinpoint.model.CreateSegmentRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val writeSegmentRequest
        : zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly =
      zio.aws.pinpoint.model.WriteSegmentRequest
        .wrap(impl.writeSegmentRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest
  ): zio.aws.pinpoint.model.CreateSegmentRequest.ReadOnly = new Wrapper(impl)
}
