package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClosedDaysRule(
    name: Optional[__string] = Optional.Absent,
    startDateTime: Optional[__string] = Optional.Absent,
    endDateTime: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule = {
    import ClosedDaysRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(startDateTime.map(value => value: java.lang.String))(
        _.startDateTime
      )
      .optionallyWith(endDateTime.map(value => value: java.lang.String))(
        _.endDateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly =
    zio.aws.pinpoint.model.ClosedDaysRule.wrap(buildAwsValue())
}
object ClosedDaysRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ClosedDaysRule =
      zio.aws.pinpoint.model.ClosedDaysRule(
        name.map(value => value),
        startDateTime.map(value => value),
        endDateTime.map(value => value)
      )
    def name: Optional[__string]
    def startDateTime: Optional[__string]
    def endDateTime: Optional[__string]
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getStartDateTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("startDateTime", startDateTime)
    def getEndDateTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule
  ) extends zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly {
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val startDateTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.startDateTime())
      .map(value => value: __string)
    override val endDateTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.endDateTime())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule
  ): zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly = new Wrapper(impl)
}
