package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.__integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CampaignLimits(
    daily: Optional[__integer] = Optional.Absent,
    maximumDuration: Optional[__integer] = Optional.Absent,
    messagesPerSecond: Optional[__integer] = Optional.Absent,
    total: Optional[__integer] = Optional.Absent,
    session: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignLimits = {
    import CampaignLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignLimits
      .builder()
      .optionallyWith(daily.map(value => value: Integer))(_.daily)
      .optionallyWith(maximumDuration.map(value => value: Integer))(
        _.maximumDuration
      )
      .optionallyWith(messagesPerSecond.map(value => value: Integer))(
        _.messagesPerSecond
      )
      .optionallyWith(total.map(value => value: Integer))(_.total)
      .optionallyWith(session.map(value => value: Integer))(_.session)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignLimits.ReadOnly =
    zio.aws.pinpoint.model.CampaignLimits.wrap(buildAwsValue())
}
object CampaignLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignLimits =
      zio.aws.pinpoint.model.CampaignLimits(
        daily.map(value => value),
        maximumDuration.map(value => value),
        messagesPerSecond.map(value => value),
        total.map(value => value),
        session.map(value => value)
      )
    def daily: Optional[__integer]
    def maximumDuration: Optional[__integer]
    def messagesPerSecond: Optional[__integer]
    def total: Optional[__integer]
    def session: Optional[__integer]
    def getDaily: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("daily", daily)
    def getMaximumDuration: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maximumDuration", maximumDuration)
    def getMessagesPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("messagesPerSecond", messagesPerSecond)
    def getTotal: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("total", total)
    def getSession: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignLimits
  ) extends zio.aws.pinpoint.model.CampaignLimits.ReadOnly {
    override val daily: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.daily())
      .map(value => value: __integer)
    override val maximumDuration: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumDuration())
      .map(value => value: __integer)
    override val messagesPerSecond: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.messagesPerSecond())
      .map(value => value: __integer)
    override val total: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => value: __integer)
    override val session: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.session())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignLimits
  ): zio.aws.pinpoint.model.CampaignLimits.ReadOnly = new Wrapper(impl)
}
