package zio.aws.pinpoint.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CampaignDateRangeKpiResponse(
    applicationId: __string,
    campaignId: __string,
    endTime: __timestampIso8601,
    kpiName: __string,
    kpiResult: zio.aws.pinpoint.model.BaseKpiResult,
    nextToken: Optional[__string] = Optional.Absent,
    startTime: __timestampIso8601
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignDateRangeKpiResponse = {
    import CampaignDateRangeKpiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignDateRangeKpiResponse
      .builder()
      .applicationId(applicationId: java.lang.String)
      .campaignId(campaignId: java.lang.String)
      .endTime(endTime: Instant)
      .kpiName(kpiName: java.lang.String)
      .kpiResult(kpiResult.buildAwsValue())
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .startTime(startTime: Instant)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignDateRangeKpiResponse.ReadOnly =
    zio.aws.pinpoint.model.CampaignDateRangeKpiResponse.wrap(buildAwsValue())
}
object CampaignDateRangeKpiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignDateRangeKpiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignDateRangeKpiResponse =
      zio.aws.pinpoint.model.CampaignDateRangeKpiResponse(
        applicationId,
        campaignId,
        endTime,
        kpiName,
        kpiResult.asEditable,
        nextToken.map(value => value),
        startTime
      )
    def applicationId: __string
    def campaignId: __string
    def endTime: __timestampIso8601
    def kpiName: __string
    def kpiResult: zio.aws.pinpoint.model.BaseKpiResult.ReadOnly
    def nextToken: Optional[__string]
    def startTime: __timestampIso8601
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCampaignId: ZIO[Any, Nothing, __string] = ZIO.succeed(campaignId)
    def getEndTime: ZIO[Any, Nothing, __timestampIso8601] = ZIO.succeed(endTime)
    def getKpiName: ZIO[Any, Nothing, __string] = ZIO.succeed(kpiName)
    def getKpiResult
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.BaseKpiResult.ReadOnly] =
      ZIO.succeed(kpiResult)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartTime: ZIO[Any, Nothing, __timestampIso8601] =
      ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignDateRangeKpiResponse
  ) extends zio.aws.pinpoint.model.CampaignDateRangeKpiResponse.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val campaignId: __string = impl.campaignId(): __string
    override val endTime: __timestampIso8601 =
      impl.endTime(): __timestampIso8601
    override val kpiName: __string = impl.kpiName(): __string
    override val kpiResult: zio.aws.pinpoint.model.BaseKpiResult.ReadOnly =
      zio.aws.pinpoint.model.BaseKpiResult.wrap(impl.kpiResult())
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val startTime: __timestampIso8601 =
      impl.startTime(): __timestampIso8601
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignDateRangeKpiResponse
  ): zio.aws.pinpoint.model.CampaignDateRangeKpiResponse.ReadOnly = new Wrapper(
    impl
  )
}
