package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BaiduChannelResponse(
    applicationId: Optional[__string] = Optional.Absent,
    creationDate: Optional[__string] = Optional.Absent,
    credential: __string,
    enabled: Optional[__boolean] = Optional.Absent,
    hasCredential: Optional[__boolean] = Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    isArchived: Optional[__boolean] = Optional.Absent,
    lastModifiedBy: Optional[__string] = Optional.Absent,
    lastModifiedDate: Optional[__string] = Optional.Absent,
    platform: __string,
    version: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.BaiduChannelResponse = {
    import BaiduChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.BaiduChannelResponse
      .builder()
      .optionallyWith(applicationId.map(value => value: java.lang.String))(
        _.applicationId
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .credential(credential: java.lang.String)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(hasCredential.map(value => value: java.lang.Boolean))(
        _.hasCredential
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(isArchived.map(value => value: java.lang.Boolean))(
        _.isArchived
      )
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.String))(
        _.lastModifiedDate
      )
      .platform(platform: java.lang.String)
      .optionallyWith(version.map(value => value: Integer))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.BaiduChannelResponse.ReadOnly =
    zio.aws.pinpoint.model.BaiduChannelResponse.wrap(buildAwsValue())
}
object BaiduChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.BaiduChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.BaiduChannelResponse =
      zio.aws.pinpoint.model.BaiduChannelResponse(
        applicationId.map(value => value),
        creationDate.map(value => value),
        credential,
        enabled.map(value => value),
        hasCredential.map(value => value),
        id.map(value => value),
        isArchived.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        platform,
        version.map(value => value)
      )
    def applicationId: Optional[__string]
    def creationDate: Optional[__string]
    def credential: __string
    def enabled: Optional[__boolean]
    def hasCredential: Optional[__boolean]
    def id: Optional[__string]
    def isArchived: Optional[__boolean]
    def lastModifiedBy: Optional[__string]
    def lastModifiedDate: Optional[__string]
    def platform: __string
    def version: Optional[__integer]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCredential: ZIO[Any, Nothing, __string] = ZIO.succeed(credential)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getHasCredential: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("hasCredential", hasCredential)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getIsArchived: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getLastModifiedBy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getPlatform: ZIO[Any, Nothing, __string] = ZIO.succeed(platform)
    def getVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.BaiduChannelResponse
  ) extends zio.aws.pinpoint.model.BaiduChannelResponse.ReadOnly {
    override val applicationId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => value: __string)
    override val creationDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: __string)
    override val credential: __string = impl.credential(): __string
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
    override val hasCredential: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasCredential())
      .map(value => value: __boolean)
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val isArchived: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isArchived())
      .map(value => value: __boolean)
    override val lastModifiedBy: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedBy())
      .map(value => value: __string)
    override val lastModifiedDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: __string)
    override val platform: __string = impl.platform(): __string
    override val version: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.BaiduChannelResponse
  ): zio.aws.pinpoint.model.BaiduChannelResponse.ReadOnly = new Wrapper(impl)
}
