package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AttributesResource(
    applicationId: __string,
    attributeType: __string,
    attributes: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.AttributesResource = {
    import AttributesResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.AttributesResource
      .builder()
      .applicationId(applicationId: java.lang.String)
      .attributeType(attributeType: java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.AttributesResource.ReadOnly =
    zio.aws.pinpoint.model.AttributesResource.wrap(buildAwsValue())
}
object AttributesResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.AttributesResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.AttributesResource =
      zio.aws.pinpoint.model.AttributesResource(
        applicationId,
        attributeType,
        attributes.map(value => value)
      )
    def applicationId: __string
    def attributeType: __string
    def attributes: Optional[List[__string]]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getAttributeType: ZIO[Any, Nothing, __string] =
      ZIO.succeed(attributeType)
    def getAttributes: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.AttributesResource
  ) extends zio.aws.pinpoint.model.AttributesResource.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val attributeType: __string = impl.attributeType(): __string
    override val attributes: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.AttributesResource
  ): zio.aws.pinpoint.model.AttributesResource.ReadOnly = new Wrapper(impl)
}
